;File:	PCDOSDSK.ASM
;Edit date:	87/01/23.
;Serial number 12
;
;	PCDOSDSK - DOS dispatch non-RSX for PC RP/M2.
;
;
;	Copyright (c) 1986 by microMethods.
;                             P.O. Box G
;                             Warrenton, Oregon  97146
;
;	Reserved locations.
;
RWBT	EQU	0000H	;warmboot vector
RIOB	EQU	0003H	;Intel iobyte
RDSK	EQU	0004H	;4/user number, 4/current disk
RDOS	EQU	0005H	;RDOS vector
RFCB	EQU	005CH	;Resident file control block
RBUF	EQU	0080H	;Resident record buffer
RTPA	EQU	0100H	;FWA for all user programs
;
;	Assembly constants.
;
VERN	EQU	12		;PCDOSDSK revision level
RECSIZ	EQU	80H	;record size
MEMSIZ	EQU	64	;memory size in k bytes
MEMPAG	EQU	MEMSIZ*4	;memory size in pages
BIOSIZ	EQU	3+11+1		;CBIOS size in pages
RDOSIZ	EQU	14		;RDOS size in pages
RCPSIZ	EQU	8		;RCP size in pages
XCPSIZ	EQU	12		;XCP size in pages
;
;	Ascii character codes.
;
cr	EQU	0DH	;carriage return
lf	EQU	0AH	;line feed
;
;	Assembler calculated memory map.
;
BIOFWA	EQU	(MEMPAG-BIOSIZ)*100H	;CBIOS fwa
RDOFWA	EQU	BIOFWA-(RDOSIZ*100H)	;RDOS fwa
RCPFWA	EQU	RDOFWA-(RCPSIZ*100H)	;RCP fwa
XCPFWA	EQU	0FB00H	;move PCDOSDSK above CBIOS80
;
;	Locations in RDOS.
;
RDOSDO	EQU	RDOFWA+17H	;directory ordinal
RDOSCF	EQU	RDOSDO+2	;current function
;
;	RDOS functions.
;
FDSR	EQU	13	;disk system reset
FSFF	EQU	17	;search for first occurence
FCNF	EQU	22	;create new file
FDMA	EQU	26	;set DMA
FCLV	EQU	37	;clear log-in vector bits
;
;	Locations in CBIOS80.
;
BIOCCO	EQU	BIOFWA+0CH	;console character out
BIOC88	EQU	BIOFWA+33H	;call CBIOS88
;
;	Assembly controls.
;
FALSE	EQU	0
TRUE	EQU	NOT FALSE
;
;	Assembly options.
;
DOSTERM	EQU	FALSE
;
;
	ORG	XCPFWA
;
;	This code image will appear at 0300H in DOSDISK.COM.
;
LBIAS	EQU	0300H-XCPFWA AND 0FFFFH	;DDT load bias
	RET			;JMP when DOSDISK active
	DW	PWB		;issue warmboot message
	DB	0,0,0
IRDOS:	JMP	DDC	;dispatch DOS call
XRDOS:	JMP	RDOFWA+6	;RDOS vector
XRDOSA	EQU	$-2
XWBT:	JMP	BIOFWA+3	;warmboot vector
XWBTA	EQU	$-2
;
;	Locations in PCDOSDSK.
;
	DW	DSEG	;RPM data segment in register array
	DW	PWB	;warmboot processor
	DW	XDISK	;assigned drive
	DW	CDISK	;current disk
	DW	IARRAY	;DOS register array
	DW	0	;(spare)
;
	DB	cr,lf,'Copyright (c) 1986 by microMethods, Inc.',0
	DB	VERN
	NOP ! NOP ! NOP
	ORG	($ AND 0FFF0H) + 10H
;
;	Data space.
;
CDISK:	DB	0	;current disk
XDISK:	DB	'                ',0FFH	;drives assigned to DOS
	DB	0
VMFLAG:	DB	0	;vectors modified flag
USRDMA:	DW	RBUF	;user's DMA
SFCBA:	DW	0	;save search fcb address
;
;	PWB - Process warmboot.
;	Issue drives assigned to DOS message.
;
PWB:	LXI	H,PWBA	;"Drive "
	CALL	MSG
	CALL	DDN	;display DOS drive names
	LXI	H,PWBB	;" set to "
	CALL	MSG
	RET
;
PWBA:	DB	cr,lf,'Drive ',0
PWBB:	DB	' processed by DOS.',0
;
;	DDN - Display DOS drive names.
;
DDN:	LXI	H,XDISK	;string of up to 8 names
;
DDN1:	MOV	A,M
	CPI	0FFH
	RZ		;If end of string
;
	PUSH	H
	MOV	C,A	;drive char out
	CALL	BIOCCO
	MVI	C,' '	;space
	CALL	BIOCCO
	POP	H
	INX	H
	JMP	DDN1	;loop to end of string
;
;	MSG - Console message out.
;	Entry	HL = fwa message ending in 00
;
MSG:	MOV	A,M
	ORA	A
	RZ		;If done
;
	PUSH	H
	MOV	C,A	;send next char
	CALL	BIOCCO
	POP	H
	INX	H
	JMP	MSG
;
;	HLA - Set HL = HL + A.
;
HLA:	ADD L ! MOV L,A ! RNC
	INR H ! RET
;
;	DDC - Dispatch DOS call.
;	Entry	 C = function number
;		DE = .fcb
;
DDC:	MOV	A,C	;go to function processor
	CPI	MAXF
	JNC	RDO3	;If DOS function
;
	ADD	A
	LXI	H,DOSTBL
	CALL	HLA
	MOV	A,M	;set HL=.processor
	INX	H
	MOV	H,M
	MOV	L,A
	PCHL		;go to processor
;
;	DOS function dispatch table.
;
DOSTBL	EQU	$
	DW	XRDOS	; 0  00  system reset
	DW	XDOS	; 1  01  console char in
	DW	XDOS	; 2  02  console char out
	DW	XRDOS	; 3  03  reader char in
	DW	XRDOS	; 4  04  punch char out
	DW	XDOS	; 5  05  list char out
	DW	XDOS	; 6  06  direct console i/o
	DW	XRDOS	; 7  07  get iobyte
	DW	XRDOS	; 8  08  set iobyte
	DW	XDOS	; 9  09  console buffer out
	DW	XDOS	;10  0A  console buffer in
	DW	XDOS	;11  0B  get console input status
	DW	XRDOS	;12  0C  get CP/M version number
	DW	XDSR	;13  0D  reset disk system
	DW	XSEL	;14  0E  select disk
	DW	XFCB	;15  0F  open file
	DW	XFCB	;16  10  close file
	DW	XSFF	;17  11  search for first occurence
	DW	XSFN	;18  12  search for next occurence
	DW	XFCB	;19  13  delete file
	DW	XRSR	;20  14  read sequential record
	DW	XFCB	;21  15  write sequential record
	DW	XFCB	;22  16  create new file
	DW	XFCB	;23  17  rename file
	DW	XRDOS	;24  18  return login vector
	DW	XRCD	;25  19  return current disk
	DW	XDMA	;26  1A  set DMA
	DW	XRDOS	;27  1B  get .RBR
	DW	XRDOS	;28  1C  write protect disk
	DW	XRDOS	;29  1D  get r/o vector
	DW	XRDOS	;30  1E  set file attributes
	DW	XRDOS	;31  1F  get .DPB
	DW	XRDOS	;32  20  set or get user number
	DW	XRSR	;33  21  read random record
	DW	XFCB	;34  22  write random record
	DW	XFCB	;35  23  compute file size
	DW	XFCB	;36  24  set random record
	DW	XRDOS	;37  25  log out drives
	DW	XRDOS	;38  26  set page size
	DW	XRDOS	;39  27  no operation
	DW	XRDOS	;40  28  write random w/zero fill
MAXF	EQU	($-DOSTBL)/2	;max function number + 1
;
;
;	RDO3 - Call MS-DOS.
;	Entry	 C = function
;		DE = .fcb
;
C88UNL	EQU	01EH
C88INT	EQU	01FH
RPMSEG	EQU	001AH	;.data segment in CBIOS88 common area
;
RDO3:	MOV	A,C	;set AH=function
	STA	AX+1
	XCHG		;set DX=.fcb
	SHLD	DX
;
;	Enable CBIOS88.
;
	MVI	D,C88UNL
	CALL	BIOC88
;
;	Process MS-DOS function.
;
	LXI	H,IARRAY
	MVI	D,C88INT
	CALL	BIOC88
;
;	Get returned registers.
;
	LXI	H,IRETURN+2
	MOV	A,M
	LXI	H,IRETURN+6
	MOV	C,M
	INX	H
	MOV	B,M
	INX	H
	MOV	E,M
	INX	H
	MOV	D,M
	LHLD	HLRET
	RET
;
;	Register array.
;
IARRAY	EQU	$
	DB	(IRETURN-IARRAY)/2	;word count
	DB	21H	;INT 21
AX:	DW	0	;AL,AH
BX:	DW	0	;BL,BH
CX:	DW	0	;CL,CH
DX:	DW	0	;DL,DH
	DW	0	;ES
	DW	0	;SI
	DW	0	;DI
DSEG:	DW	0	;DS
;
IRETURN	EQU	$
	DW	0	;flags
	DW	0	;AX  A,xx
HLRET	EQU	$
	DW	0	;BX  L,H
	DW	0	;CX  C,B
	DW	0	;DX  E,D
	DW	0	;ES
	DW	0	;SI
	DW	0	;DI
	DW	0	;DS
;
;	Define dispatch table entries for DOSTERM.
;
	IF	DOSTERM
XDOS	EQU	RDO3
	ENDIF
;
	IF	NOT DOSTERM
XDOS	EQU	XRDOS
	ENDIF
;
;	CDD - Check DOS disk.
;	Entry	 E = device number
;	Exit	 Z = true, if DOS disk
;
CDD:	LXI	H,XDISK	;table of DOS disks
;
CDD1:	MOV	A,M
	ORA	A
	RM		;If end of table
;
	SUI	'A'
	CMP	E
	RZ		;If DOS disk
;
	INX	H
	JMP	CDD1	;loop to end of table
;
;	PXF - Process DOS extended fcb.
;	Entry	DE = .fcb
;	Exit	 A = device number
;
PXF:	XCHG		;HL=xfcb fwa
	MVI	A,7	;point to device byte
	CALL	HLA
	MOV	A,M	;device number
	XCHG
	RET
;
;	XDSR - Process disk system reset.
;
XDSR:	CALL	RDO3	;reset DOS
	MVI	A,0	;reset current disk
	STA	CDISK
;
;	Reset default DMA.
;
	MVI	C,FDMA
	LXI	D,RBUF
	CALL	XDMA
;
;	To avoid the select of drive A that RDOS invokes
;	in processing function 0D, omit RP/M funciton 0D
;	while drive A is assigned to DOS.
;
	MVI	E,0
	CALL	CDD
	RZ		;If drive A assigned to DOS
;
	MVI	C,FDSR
	JMP	XRDOS	;reset RP/M
;
;	XSEL - Process select disk.
;	Entry	 E = disk device number
;
XSEL	EQU	$
	MOV	A,E
	STA	CDISK	;set current disk
	CALL	CDD	;check DOS disk
	JZ	XSEL1	;If DOS disk
;
;	Select RP/M disk.
;
	JMP	XRDOS
;
;	Select DOS disk.
;
XSEL1:	CALL	RDO3
	MVI	A,0	;no submit files
	RET
;
;	XFCB - Process fcb function.
;	Entry	 C = function
;		DE = .fcb
;
XFCB:	PUSH	D	;save .fcb
	LDAX	D	;get fcb(0)
	CPI	0FFH	
	CZ	PXF	;If DOS extended fcb
;
	ORA	A
	JZ	XFCB2	;If no auto-select
;
;	Process auto-select.
;
	DCR	A
XFCB1:	MOV	E,A
	CALL	CDD	;check DOS disk
	POP	D	;restore .fcb
	JZ	RDO3	;If DOS disk
;
;	Process RP/M disk.
;
	JMP	XRDOS
;
;	Process this function on the current disk.
;
XFCB2:	LDA	CDISK	;current disk
	JMP	XFCB1
;
;	XRCD - Process return current disk.
;	Exit	 A = current disk
;
XRCD:	LDA	CDISK
	RET
;
;	XDMA - Process set disk memory address.
;	Entry	DE = DMA
;	Exit	HL = .IARRAY
;
XDMA:	XCHG
	SHLD	USRDMA
	XCHG
	CALL	RDO3	;set DOS DMA
;
	LHLD	USRDMA
	XCHG
	MVI	C,FDMA	;restore reg C
	CALL	XRDOS	;set RP/M DMA
	LXI	H,IARRAY
	RET
;
;	XRSR - Process read sequential record.
;
XRSR:	CALL	XFCB	;process the function
	CPI	03H
	RNZ		;If not DOS style eoi
;
;	Since we have data, indicate not eoi.
;
	MVI	A,00
	RET
;
;	MBB - Move B bytes.
;	Entry	DE = source
;		HL = destination
;		 B = byte count
;
MBB:	LDAX D ! MOV M,A
	INX D  ! INX H
	DCR b  ! JNZ MBB	;loop for B bytes
	RET
;
;	XSFF - Process search for first occurence.
;	Save the fcb address for SFN.
;
XSFF:	LXI	H,SFCB	;copy the fcb
	MVI	B,32
	CALL	MBB
	LXI	D,SFCB
	LDAX	D	;fcb(0)
	CPI	'?'
	CZ	XSFF1	;If return-all-entries
	JMP	XFCB
;
;	XSFF1 - Process return-all-entries type search.
;	For DOS, clear fcb(0) and set filename=*.*.
;
XSFF1:	PUSH	D	;save .fcb
	LDA	CDISK	;check current disk=DOS
	MOV	E,A
	CALL	CDD	;check DOS disk
	POP	D
	RNZ		;If current disk belongs to RP/M
;
;	Modify the fcb for DOS.
;
	MOV	H,D	;HL=.fcb
	MOV	L,E
	MVI	M,0	;fcb(0)=0
	MVI	B,8+3	;fill filename with '?'
XSFF2:	INX	H
	MVI	M,'?'
	DCR	B
	JNZ	XSFF2	;loop over filename
	RET
;
;	XSFN - Process search for next occurence.
;	Restore DE for MS-DOS.
;
XSFN:	LXI	D,SFCB
	JMP	XFCB
;
;	Search function fcb.
;
SFCB:	DS	32
